package io.burkard.cdk.services.ses

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object EmailIdentity {

  def apply(
    internalResourceId: String,
    identity: software.amazon.awscdk.services.ses.Identity,
    feedbackForwarding: Option[Boolean] = None,
    mailFromBehaviorOnMxFailure: Option[software.amazon.awscdk.services.ses.MailFromBehaviorOnMxFailure] = None,
    mailFromDomain: Option[String] = None,
    configurationSet: Option[software.amazon.awscdk.services.ses.IConfigurationSet] = None,
    dkimIdentity: Option[software.amazon.awscdk.services.ses.DkimIdentity] = None,
    dkimSigning: Option[Boolean] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.ses.EmailIdentity =
    software.amazon.awscdk.services.ses.EmailIdentity.Builder
      .create(stackCtx, internalResourceId)
      .identity(identity)
      .feedbackForwarding(feedbackForwarding.map(Boolean.box).orNull)
      .mailFromBehaviorOnMxFailure(mailFromBehaviorOnMxFailure.orNull)
      .mailFromDomain(mailFromDomain.orNull)
      .configurationSet(configurationSet.orNull)
      .dkimIdentity(dkimIdentity.orNull)
      .dkimSigning(dkimSigning.map(Boolean.box).orNull)
      .build()
}
