package io.burkard.cdk.services.ses

sealed abstract class EasyDkimSigningKeyLength(val underlying: software.amazon.awscdk.services.ses.EasyDkimSigningKeyLength)
  extends Product
    with Serializable

object EasyDkimSigningKeyLength {
  implicit def toAws(value: EasyDkimSigningKeyLength): software.amazon.awscdk.services.ses.EasyDkimSigningKeyLength =
    Option(value).map(_.underlying).orNull

  case object Rsa1024Bit
    extends EasyDkimSigningKeyLength(software.amazon.awscdk.services.ses.EasyDkimSigningKeyLength.RSA_1024_BIT)

  case object Rsa2048Bit
    extends EasyDkimSigningKeyLength(software.amazon.awscdk.services.ses.EasyDkimSigningKeyLength.RSA_2048_BIT)
}
