package io.burkard.cdk.services.ses

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnEmailIdentity {

  def apply(
    internalResourceId: String,
    emailIdentity: String,
    configurationSetAttributes: Option[software.amazon.awscdk.services.ses.CfnEmailIdentity.ConfigurationSetAttributesProperty] = None,
    dkimAttributes: Option[software.amazon.awscdk.services.ses.CfnEmailIdentity.DkimAttributesProperty] = None,
    mailFromAttributes: Option[software.amazon.awscdk.services.ses.CfnEmailIdentity.MailFromAttributesProperty] = None,
    dkimSigningAttributes: Option[software.amazon.awscdk.services.ses.CfnEmailIdentity.DkimSigningAttributesProperty] = None,
    feedbackAttributes: Option[software.amazon.awscdk.services.ses.CfnEmailIdentity.FeedbackAttributesProperty] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.ses.CfnEmailIdentity =
    software.amazon.awscdk.services.ses.CfnEmailIdentity.Builder
      .create(stackCtx, internalResourceId)
      .emailIdentity(emailIdentity)
      .configurationSetAttributes(configurationSetAttributes.orNull)
      .dkimAttributes(dkimAttributes.orNull)
      .mailFromAttributes(mailFromAttributes.orNull)
      .dkimSigningAttributes(dkimSigningAttributes.orNull)
      .feedbackAttributes(feedbackAttributes.orNull)
      .build()
}
