package io.burkard.cdk.services.ses

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnConfigurationSet {

  def apply(
    internalResourceId: String,
    name: Option[String] = None,
    suppressionOptions: Option[software.amazon.awscdk.services.ses.CfnConfigurationSet.SuppressionOptionsProperty] = None,
    reputationOptions: Option[software.amazon.awscdk.services.ses.CfnConfigurationSet.ReputationOptionsProperty] = None,
    trackingOptions: Option[software.amazon.awscdk.services.ses.CfnConfigurationSet.TrackingOptionsProperty] = None,
    sendingOptions: Option[software.amazon.awscdk.services.ses.CfnConfigurationSet.SendingOptionsProperty] = None,
    deliveryOptions: Option[software.amazon.awscdk.services.ses.CfnConfigurationSet.DeliveryOptionsProperty] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.ses.CfnConfigurationSet =
    software.amazon.awscdk.services.ses.CfnConfigurationSet.Builder
      .create(stackCtx, internalResourceId)
      .name(name.orNull)
      .suppressionOptions(suppressionOptions.orNull)
      .reputationOptions(reputationOptions.orNull)
      .trackingOptions(trackingOptions.orNull)
      .sendingOptions(sendingOptions.orNull)
      .deliveryOptions(deliveryOptions.orNull)
      .build()
}
