package io.burkard.cdk.services.ses

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ByoDkimOptions {

  def apply(
    selector: String,
    privateKey: software.amazon.awscdk.SecretValue,
    publicKey: Option[String] = None
  ): software.amazon.awscdk.services.ses.ByoDkimOptions =
    (new software.amazon.awscdk.services.ses.ByoDkimOptions.Builder)
      .selector(selector)
      .privateKey(privateKey)
      .publicKey(publicKey.orNull)
      .build()
}
