package io.burkard.cdk.services.servicediscovery

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnInstanceProps {

  def apply(
    serviceId: String,
    instanceAttributes: AnyRef,
    instanceId: Option[String] = None
  ): software.amazon.awscdk.services.servicediscovery.CfnInstanceProps =
    (new software.amazon.awscdk.services.servicediscovery.CfnInstanceProps.Builder)
      .serviceId(serviceId)
      .instanceAttributes(instanceAttributes)
      .instanceId(instanceId.orNull)
      .build()
}
