package io.burkard.cdk.services.servicecatalog

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object Portfolio {

  def apply(
    internalResourceId: String,
    displayName: String,
    providerName: String,
    messageLanguage: Option[software.amazon.awscdk.services.servicecatalog.MessageLanguage] = None,
    description: Option[String] = None,
    tagOptions: Option[software.amazon.awscdk.services.servicecatalog.TagOptions] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.servicecatalog.Portfolio =
    software.amazon.awscdk.services.servicecatalog.Portfolio.Builder
      .create(stackCtx, internalResourceId)
      .displayName(displayName)
      .providerName(providerName)
      .messageLanguage(messageLanguage.orNull)
      .description(description.orNull)
      .tagOptions(tagOptions.orNull)
      .build()
}
