package io.burkard.cdk.services.servicecatalog

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnPortfolioShare {

  def apply(
    internalResourceId: String,
    accountId: String,
    portfolioId: String,
    shareTagOptions: Option[Boolean] = None,
    acceptLanguage: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.servicecatalog.CfnPortfolioShare =
    software.amazon.awscdk.services.servicecatalog.CfnPortfolioShare.Builder
      .create(stackCtx, internalResourceId)
      .accountId(accountId)
      .portfolioId(portfolioId)
      .shareTagOptions(shareTagOptions.map(Boolean.box).orNull)
      .acceptLanguage(acceptLanguage.orNull)
      .build()
}
