package io.burkard.cdk.services.secretsmanager

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object Secret {

  def apply(
    internalResourceId: String,
    replicaRegions: Option[List[_ <: software.amazon.awscdk.services.secretsmanager.ReplicaRegion]] = None,
    description: Option[String] = None,
    secretObjectValue: Option[Map[String, _ <: software.amazon.awscdk.SecretValue]] = None,
    secretName: Option[String] = None,
    generateSecretString: Option[software.amazon.awscdk.services.secretsmanager.SecretStringGenerator] = None,
    secretStringValue: Option[software.amazon.awscdk.SecretValue] = None,
    secretStringBeta1: Option[software.amazon.awscdk.services.secretsmanager.SecretStringValueBeta1] = None,
    encryptionKey: Option[software.amazon.awscdk.services.kms.IKey] = None,
    removalPolicy: Option[software.amazon.awscdk.RemovalPolicy] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.secretsmanager.Secret =
    software.amazon.awscdk.services.secretsmanager.Secret.Builder
      .create(stackCtx, internalResourceId)
      .replicaRegions(replicaRegions.map(_.asJava).orNull)
      .description(description.orNull)
      .secretObjectValue(secretObjectValue.map(_.asJava).orNull)
      .secretName(secretName.orNull)
      .generateSecretString(generateSecretString.orNull)
      .secretStringValue(secretStringValue.orNull)
      .secretStringBeta1(secretStringBeta1.orNull)
      .encryptionKey(encryptionKey.orNull)
      .removalPolicy(removalPolicy.orNull)
      .build()
}
