package io.burkard.cdk.services.sam.cfnApi

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object DomainConfigurationProperty {

  def apply(
    domainName: String,
    certificateArn: String,
    basePath: Option[List[String]] = None,
    mutualTlsAuthentication: Option[software.amazon.awscdk.services.sam.CfnApi.MutualTlsAuthenticationProperty] = None,
    ownershipVerificationCertificateArn: Option[String] = None,
    endpointConfiguration: Option[String] = None,
    securityPolicy: Option[String] = None,
    route53: Option[software.amazon.awscdk.services.sam.CfnApi.Route53ConfigurationProperty] = None
  ): software.amazon.awscdk.services.sam.CfnApi.DomainConfigurationProperty =
    (new software.amazon.awscdk.services.sam.CfnApi.DomainConfigurationProperty.Builder)
      .domainName(domainName)
      .certificateArn(certificateArn)
      .basePath(basePath.map(_.asJava).orNull)
      .mutualTlsAuthentication(mutualTlsAuthentication.orNull)
      .ownershipVerificationCertificateArn(ownershipVerificationCertificateArn.orNull)
      .endpointConfiguration(endpointConfiguration.orNull)
      .securityPolicy(securityPolicy.orNull)
      .route53(route53.orNull)
      .build()
}
