package io.burkard.cdk.services.sam

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnFunction {

  def apply(
    internalResourceId: String,
    autoPublishCodeSha256: Option[String] = None,
    provisionedConcurrencyConfig: Option[software.amazon.awscdk.services.sam.CfnFunction.ProvisionedConcurrencyConfigProperty] = None,
    layers: Option[List[String]] = None,
    functionName: Option[String] = None,
    role: Option[String] = None,
    permissionsBoundary: Option[String] = None,
    description: Option[String] = None,
    tags: Option[Map[String, String]] = None,
    deadLetterQueue: Option[software.amazon.awscdk.services.sam.CfnFunction.DeadLetterQueueProperty] = None,
    deploymentPreference: Option[software.amazon.awscdk.services.sam.CfnFunction.DeploymentPreferenceProperty] = None,
    imageUri: Option[String] = None,
    vpcConfig: Option[software.amazon.awscdk.services.sam.CfnFunction.VpcConfigProperty] = None,
    assumeRolePolicyDocument: Option[AnyRef] = None,
    memorySize: Option[Number] = None,
    fileSystemConfigs: Option[List[_]] = None,
    kmsKeyArn: Option[String] = None,
    inlineCode: Option[String] = None,
    eventInvokeConfig: Option[software.amazon.awscdk.services.sam.CfnFunction.EventInvokeConfigProperty] = None,
    packageType: Option[String] = None,
    autoPublishAlias: Option[String] = None,
    reservedConcurrentExecutions: Option[Number] = None,
    codeUri0: Option[software.amazon.awscdk.services.sam.CfnFunction.S3LocationProperty] = None,
    codeUri1: Option[String] = None,
    environment: Option[software.amazon.awscdk.services.sam.CfnFunction.FunctionEnvironmentProperty] = None,
    codeSigningConfigArn: Option[String] = None,
    imageConfig: Option[software.amazon.awscdk.services.sam.CfnFunction.ImageConfigProperty] = None,
    versionDescription: Option[String] = None,
    tracing: Option[String] = None,
    timeout: Option[Number] = None,
    handler: Option[String] = None,
    events: Option[Map[String, _]] = None,
    runtime: Option[String] = None,
    architectures: Option[List[String]] = None,
    policies0: Option[List[_]] = None,
    policies1: Option[String] = None,
    policies2: Option[software.amazon.awscdk.services.sam.CfnFunction.IAMPolicyDocumentProperty] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.sam.CfnFunction =
    software.amazon.awscdk.services.sam.CfnFunction.Builder
      .create(stackCtx, internalResourceId)
      .autoPublishCodeSha256(autoPublishCodeSha256.orNull)
      .provisionedConcurrencyConfig(provisionedConcurrencyConfig.orNull)
      .layers(layers.map(_.asJava).orNull)
      .functionName(functionName.orNull)
      .role(role.orNull)
      .permissionsBoundary(permissionsBoundary.orNull)
      .description(description.orNull)
      .tags(tags.map(_.asJava).orNull)
      .deadLetterQueue(deadLetterQueue.orNull)
      .deploymentPreference(deploymentPreference.orNull)
      .imageUri(imageUri.orNull)
      .vpcConfig(vpcConfig.orNull)
      .assumeRolePolicyDocument(assumeRolePolicyDocument.orNull)
      .memorySize(memorySize.orNull)
      .fileSystemConfigs(fileSystemConfigs.map(_.asJava).orNull)
      .kmsKeyArn(kmsKeyArn.orNull)
      .inlineCode(inlineCode.orNull)
      .eventInvokeConfig(eventInvokeConfig.orNull)
      .packageType(packageType.orNull)
      .autoPublishAlias(autoPublishAlias.orNull)
      .reservedConcurrentExecutions(reservedConcurrentExecutions.orNull)
      .codeUri(codeUri0.orNull)
      .codeUri(codeUri1.orNull)
      .environment(environment.orNull)
      .codeSigningConfigArn(codeSigningConfigArn.orNull)
      .imageConfig(imageConfig.orNull)
      .versionDescription(versionDescription.orNull)
      .tracing(tracing.orNull)
      .timeout(timeout.orNull)
      .handler(handler.orNull)
      .events(events.map(_.asJava).orNull)
      .runtime(runtime.orNull)
      .architectures(architectures.map(_.asJava).orNull)
      .policies(policies0.map(_.asJava).orNull)
      .policies(policies1.orNull)
      .policies(policies2.orNull)
      .build()
}
