package io.burkard.cdk.services.s3.cfnBucket

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object NoncurrentVersionTransitionProperty {

  def apply(
    transitionInDays: Number,
    storageClass: String,
    newerNoncurrentVersions: Option[Number] = None
  ): software.amazon.awscdk.services.s3.CfnBucket.NoncurrentVersionTransitionProperty =
    (new software.amazon.awscdk.services.s3.CfnBucket.NoncurrentVersionTransitionProperty.Builder)
      .transitionInDays(transitionInDays)
      .storageClass(storageClass)
      .newerNoncurrentVersions(newerNoncurrentVersions.orNull)
      .build()
}
