package io.burkard.cdk.services.route53

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ZoneDelegationRecord {

  def apply(
    internalResourceId: String,
    nameServers: List[String],
    recordName: Option[String] = None,
    comment: Option[String] = None,
    ttl: Option[software.amazon.awscdk.Duration] = None,
    deleteExisting: Option[Boolean] = None,
    zone: Option[software.amazon.awscdk.services.route53.IHostedZone] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.route53.ZoneDelegationRecord =
    software.amazon.awscdk.services.route53.ZoneDelegationRecord.Builder
      .create(stackCtx, internalResourceId)
      .nameServers(nameServers.asJava)
      .recordName(recordName.orNull)
      .comment(comment.orNull)
      .ttl(ttl.orNull)
      .deleteExisting(deleteExisting.map(Boolean.box).orNull)
      .zone(zone.orNull)
      .build()
}
