package io.burkard.cdk.services.route53

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object SrvRecordProps {

  def apply(
    values: List[_ <: software.amazon.awscdk.services.route53.SrvRecordValue],
    recordName: Option[String] = None,
    comment: Option[String] = None,
    ttl: Option[software.amazon.awscdk.Duration] = None,
    deleteExisting: Option[Boolean] = None,
    zone: Option[software.amazon.awscdk.services.route53.IHostedZone] = None
  ): software.amazon.awscdk.services.route53.SrvRecordProps =
    (new software.amazon.awscdk.services.route53.SrvRecordProps.Builder)
      .values(values.asJava)
      .recordName(recordName.orNull)
      .comment(comment.orNull)
      .ttl(ttl.orNull)
      .deleteExisting(deleteExisting.map(Boolean.box).orNull)
      .zone(zone.orNull)
      .build()
}
