package io.burkard.cdk.services.route53

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnCidrCollectionProps {

  def apply(
    name: String,
    locations: Option[List[_]] = None
  ): software.amazon.awscdk.services.route53.CfnCidrCollectionProps =
    (new software.amazon.awscdk.services.route53.CfnCidrCollectionProps.Builder)
      .name(name)
      .locations(locations.map(_.asJava).orNull)
      .build()
}
