package io.burkard.cdk.services.route53

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnCidrCollection {

  def apply(
    internalResourceId: String,
    name: String,
    locations: Option[List[_]] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.route53.CfnCidrCollection =
    software.amazon.awscdk.services.route53.CfnCidrCollection.Builder
      .create(stackCtx, internalResourceId)
      .name(name)
      .locations(locations.map(_.asJava).orNull)
      .build()
}
