package io.burkard.cdk.services.route53

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ARecordProps {

  def apply(
    target: software.amazon.awscdk.services.route53.RecordTarget,
    recordName: Option[String] = None,
    comment: Option[String] = None,
    ttl: Option[software.amazon.awscdk.Duration] = None,
    deleteExisting: Option[Boolean] = None,
    zone: Option[software.amazon.awscdk.services.route53.IHostedZone] = None
  ): software.amazon.awscdk.services.route53.ARecordProps =
    (new software.amazon.awscdk.services.route53.ARecordProps.Builder)
      .target(target)
      .recordName(recordName.orNull)
      .comment(comment.orNull)
      .ttl(ttl.orNull)
      .deleteExisting(deleteExisting.map(Boolean.box).orNull)
      .zone(zone.orNull)
      .build()
}
