package io.burkard.cdk.services.refactorspaces

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnRouteProps {

  def apply(
    applicationIdentifier: String,
    environmentIdentifier: String,
    serviceIdentifier: String,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    uriPathRoute: Option[software.amazon.awscdk.services.refactorspaces.CfnRoute.UriPathRouteInputProperty] = None,
    defaultRoute: Option[software.amazon.awscdk.services.refactorspaces.CfnRoute.DefaultRouteInputProperty] = None,
    routeType: Option[String] = None
  ): software.amazon.awscdk.services.refactorspaces.CfnRouteProps =
    (new software.amazon.awscdk.services.refactorspaces.CfnRouteProps.Builder)
      .applicationIdentifier(applicationIdentifier)
      .environmentIdentifier(environmentIdentifier)
      .serviceIdentifier(serviceIdentifier)
      .tags(tags.map(_.asJava).orNull)
      .uriPathRoute(uriPathRoute.orNull)
      .defaultRoute(defaultRoute.orNull)
      .routeType(routeType.orNull)
      .build()
}
