package io.burkard.cdk.services.redshiftserverless

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnWorkgroupProps {

  def apply(
    workgroupName: String,
    subnetIds: Option[List[String]] = None,
    enhancedVpcRouting: Option[Boolean] = None,
    baseCapacity: Option[Number] = None,
    namespaceName: Option[String] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    securityGroupIds: Option[List[String]] = None,
    configParameters: Option[List[_]] = None,
    publiclyAccessible: Option[Boolean] = None
  ): software.amazon.awscdk.services.redshiftserverless.CfnWorkgroupProps =
    (new software.amazon.awscdk.services.redshiftserverless.CfnWorkgroupProps.Builder)
      .workgroupName(workgroupName)
      .subnetIds(subnetIds.map(_.asJava).orNull)
      .enhancedVpcRouting(enhancedVpcRouting.map(Boolean.box).orNull)
      .baseCapacity(baseCapacity.orNull)
      .namespaceName(namespaceName.orNull)
      .tags(tags.map(_.asJava).orNull)
      .securityGroupIds(securityGroupIds.map(_.asJava).orNull)
      .configParameters(configParameters.map(_.asJava).orNull)
      .publiclyAccessible(publiclyAccessible.map(Boolean.box).orNull)
      .build()
}
