package io.burkard.cdk.services.redshiftserverless

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnNamespace {

  def apply(
    internalResourceId: String,
    namespaceName: String,
    logExports: Option[List[String]] = None,
    defaultIamRoleArn: Option[String] = None,
    dbName: Option[String] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    adminUsername: Option[String] = None,
    adminUserPassword: Option[String] = None,
    finalSnapshotRetentionPeriod: Option[Number] = None,
    kmsKeyId: Option[String] = None,
    iamRoles: Option[List[String]] = None,
    finalSnapshotName: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.redshiftserverless.CfnNamespace =
    software.amazon.awscdk.services.redshiftserverless.CfnNamespace.Builder
      .create(stackCtx, internalResourceId)
      .namespaceName(namespaceName)
      .logExports(logExports.map(_.asJava).orNull)
      .defaultIamRoleArn(defaultIamRoleArn.orNull)
      .dbName(dbName.orNull)
      .tags(tags.map(_.asJava).orNull)
      .adminUsername(adminUsername.orNull)
      .adminUserPassword(adminUserPassword.orNull)
      .finalSnapshotRetentionPeriod(finalSnapshotRetentionPeriod.orNull)
      .kmsKeyId(kmsKeyId.orNull)
      .iamRoles(iamRoles.map(_.asJava).orNull)
      .finalSnapshotName(finalSnapshotName.orNull)
      .build()
}
