package io.burkard.cdk.services.pinpoint

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnEmailTemplate {

  def apply(
    internalResourceId: String,
    subject: String,
    templateName: String,
    textPart: Option[String] = None,
    templateDescription: Option[String] = None,
    defaultSubstitutions: Option[String] = None,
    htmlPart: Option[String] = None,
    tags: Option[AnyRef] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.pinpoint.CfnEmailTemplate =
    software.amazon.awscdk.services.pinpoint.CfnEmailTemplate.Builder
      .create(stackCtx, internalResourceId)
      .subject(subject)
      .templateName(templateName)
      .textPart(textPart.orNull)
      .templateDescription(templateDescription.orNull)
      .defaultSubstitutions(defaultSubstitutions.orNull)
      .htmlPart(htmlPart.orNull)
      .tags(tags.orNull)
      .build()
}
