package io.burkard.cdk.services.networkmanager

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnCustomerGatewayAssociation {

  def apply(
    internalResourceId: String,
    customerGatewayArn: String,
    globalNetworkId: String,
    deviceId: String,
    linkId: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.networkmanager.CfnCustomerGatewayAssociation =
    software.amazon.awscdk.services.networkmanager.CfnCustomerGatewayAssociation.Builder
      .create(stackCtx, internalResourceId)
      .customerGatewayArn(customerGatewayArn)
      .globalNetworkId(globalNetworkId)
      .deviceId(deviceId)
      .linkId(linkId.orNull)
      .build()
}
