package io.burkard.cdk.services.networkmanager

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnCoreNetwork {

  def apply(
    internalResourceId: String,
    globalNetworkId: String,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    description: Option[String] = None,
    policyDocument: Option[AnyRef] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.networkmanager.CfnCoreNetwork =
    software.amazon.awscdk.services.networkmanager.CfnCoreNetwork.Builder
      .create(stackCtx, internalResourceId)
      .globalNetworkId(globalNetworkId)
      .tags(tags.map(_.asJava).orNull)
      .description(description.orNull)
      .policyDocument(policyDocument.orNull)
      .build()
}
