package io.burkard.cdk.services.logs

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CrossAccountDestinationProps {

  def apply(
    targetArn: String,
    role: software.amazon.awscdk.services.iam.IRole,
    destinationName: Option[String] = None
  ): software.amazon.awscdk.services.logs.CrossAccountDestinationProps =
    (new software.amazon.awscdk.services.logs.CrossAccountDestinationProps.Builder)
      .targetArn(targetArn)
      .role(role)
      .destinationName(destinationName.orNull)
      .build()
}
