package io.burkard.cdk.services.lex.cfnBot

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object StillWaitingResponseSpecificationProperty {

  def apply(
    messageGroupsList: List[_],
    timeoutInSeconds: Number,
    frequencyInSeconds: Number,
    allowInterrupt: Option[Boolean] = None
  ): software.amazon.awscdk.services.lex.CfnBot.StillWaitingResponseSpecificationProperty =
    (new software.amazon.awscdk.services.lex.CfnBot.StillWaitingResponseSpecificationProperty.Builder)
      .messageGroupsList(messageGroupsList.asJava)
      .timeoutInSeconds(timeoutInSeconds)
      .frequencyInSeconds(frequencyInSeconds)
      .allowInterrupt(allowInterrupt.map(Boolean.box).orNull)
      .build()
}
