package io.burkard.cdk.services.lambda

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object FunctionUrlProps {

  def apply(
    function: software.amazon.awscdk.services.lambda.IFunction,
    authType: Option[software.amazon.awscdk.services.lambda.FunctionUrlAuthType] = None,
    cors: Option[software.amazon.awscdk.services.lambda.FunctionUrlCorsOptions] = None
  ): software.amazon.awscdk.services.lambda.FunctionUrlProps =
    (new software.amazon.awscdk.services.lambda.FunctionUrlProps.Builder)
      .function(function)
      .authType(authType.orNull)
      .cors(cors.orNull)
      .build()
}
