package io.burkard.cdk.services.lambda

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object EventSourceMapping {

  def apply(
    internalResourceId: String,
    target: software.amazon.awscdk.services.lambda.IFunction,
    batchSize: Option[Number] = None,
    parallelizationFactor: Option[Number] = None,
    enabled: Option[Boolean] = None,
    sourceAccessConfigurations: Option[List[_ <: software.amazon.awscdk.services.lambda.SourceAccessConfiguration]] = None,
    tumblingWindow: Option[software.amazon.awscdk.Duration] = None,
    maxRecordAge: Option[software.amazon.awscdk.Duration] = None,
    bisectBatchOnError: Option[Boolean] = None,
    eventSourceArn: Option[String] = None,
    maxBatchingWindow: Option[software.amazon.awscdk.Duration] = None,
    kafkaTopic: Option[String] = None,
    kafkaBootstrapServers: Option[List[String]] = None,
    reportBatchItemFailures: Option[Boolean] = None,
    startingPosition: Option[software.amazon.awscdk.services.lambda.StartingPosition] = None,
    retryAttempts: Option[Number] = None,
    onFailure: Option[software.amazon.awscdk.services.lambda.IEventSourceDlq] = None,
    startingPositionTimestamp: Option[Number] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.lambda.EventSourceMapping =
    software.amazon.awscdk.services.lambda.EventSourceMapping.Builder
      .create(stackCtx, internalResourceId)
      .target(target)
      .batchSize(batchSize.orNull)
      .parallelizationFactor(parallelizationFactor.orNull)
      .enabled(enabled.map(Boolean.box).orNull)
      .sourceAccessConfigurations(sourceAccessConfigurations.map(_.asJava).orNull)
      .tumblingWindow(tumblingWindow.orNull)
      .maxRecordAge(maxRecordAge.orNull)
      .bisectBatchOnError(bisectBatchOnError.map(Boolean.box).orNull)
      .eventSourceArn(eventSourceArn.orNull)
      .maxBatchingWindow(maxBatchingWindow.orNull)
      .kafkaTopic(kafkaTopic.orNull)
      .kafkaBootstrapServers(kafkaBootstrapServers.map(_.asJava).orNull)
      .reportBatchItemFailures(reportBatchItemFailures.map(Boolean.box).orNull)
      .startingPosition(startingPosition.orNull)
      .retryAttempts(retryAttempts.orNull)
      .onFailure(onFailure.orNull)
      .startingPositionTimestamp(startingPositionTimestamp.orNull)
      .build()
}
