package io.burkard.cdk.services.lakeformation

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnTag {

  def apply(
    internalResourceId: String,
    tagKey: String,
    tagValues: List[String],
    catalogId: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.lakeformation.CfnTag =
    software.amazon.awscdk.services.lakeformation.CfnTag.Builder
      .create(stackCtx, internalResourceId)
      .tagKey(tagKey)
      .tagValues(tagValues.asJava)
      .catalogId(catalogId.orNull)
      .build()
}
