package io.burkard.cdk.services.lakeformation

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnPrincipalPermissionsProps {

  def apply(
    permissionsWithGrantOption: List[String],
    permissions: List[String],
    resource: software.amazon.awscdk.services.lakeformation.CfnPrincipalPermissions.ResourceProperty,
    principal: software.amazon.awscdk.services.lakeformation.CfnPrincipalPermissions.DataLakePrincipalProperty,
    catalog: Option[String] = None
  ): software.amazon.awscdk.services.lakeformation.CfnPrincipalPermissionsProps =
    (new software.amazon.awscdk.services.lakeformation.CfnPrincipalPermissionsProps.Builder)
      .permissionsWithGrantOption(permissionsWithGrantOption.asJava)
      .permissions(permissions.asJava)
      .resource(resource)
      .principal(principal)
      .catalog(catalog.orNull)
      .build()
}
