package io.burkard.cdk.services.lakeformation

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnPrincipalPermissions {

  def apply(
    internalResourceId: String,
    permissionsWithGrantOption: List[String],
    permissions: List[String],
    resource: software.amazon.awscdk.services.lakeformation.CfnPrincipalPermissions.ResourceProperty,
    principal: software.amazon.awscdk.services.lakeformation.CfnPrincipalPermissions.DataLakePrincipalProperty,
    catalog: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.lakeformation.CfnPrincipalPermissions =
    software.amazon.awscdk.services.lakeformation.CfnPrincipalPermissions.Builder
      .create(stackCtx, internalResourceId)
      .permissionsWithGrantOption(permissionsWithGrantOption.asJava)
      .permissions(permissions.asJava)
      .resource(resource)
      .principal(principal)
      .catalog(catalog.orNull)
      .build()
}
