package io.burkard.cdk.services.lakeformation

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnDataCellsFilterProps {

  def apply(
    name: String,
    tableName: String,
    tableCatalogId: String,
    databaseName: String,
    columnWildcard: Option[software.amazon.awscdk.services.lakeformation.CfnDataCellsFilter.ColumnWildcardProperty] = None,
    columnNames: Option[List[String]] = None,
    rowFilter: Option[software.amazon.awscdk.services.lakeformation.CfnDataCellsFilter.RowFilterProperty] = None
  ): software.amazon.awscdk.services.lakeformation.CfnDataCellsFilterProps =
    (new software.amazon.awscdk.services.lakeformation.CfnDataCellsFilterProps.Builder)
      .name(name)
      .tableName(tableName)
      .tableCatalogId(tableCatalogId)
      .databaseName(databaseName)
      .columnWildcard(columnWildcard.orNull)
      .columnNames(columnNames.map(_.asJava).orNull)
      .rowFilter(rowFilter.orNull)
      .build()
}
