package io.burkard.cdk.services.lakeformation

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnDataCellsFilter {

  def apply(
    internalResourceId: String,
    name: String,
    tableName: String,
    tableCatalogId: String,
    databaseName: String,
    columnWildcard: Option[software.amazon.awscdk.services.lakeformation.CfnDataCellsFilter.ColumnWildcardProperty] = None,
    columnNames: Option[List[String]] = None,
    rowFilter: Option[software.amazon.awscdk.services.lakeformation.CfnDataCellsFilter.RowFilterProperty] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.lakeformation.CfnDataCellsFilter =
    software.amazon.awscdk.services.lakeformation.CfnDataCellsFilter.Builder
      .create(stackCtx, internalResourceId)
      .name(name)
      .tableName(tableName)
      .tableCatalogId(tableCatalogId)
      .databaseName(databaseName)
      .columnWildcard(columnWildcard.orNull)
      .columnNames(columnNames.map(_.asJava).orNull)
      .rowFilter(rowFilter.orNull)
      .build()
}
