package io.burkard.cdk.services.kinesisvideo

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnSignalingChannel {

  def apply(
    internalResourceId: String,
    name: Option[String] = None,
    `type`: Option[String] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    messageTtlSeconds: Option[Number] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.kinesisvideo.CfnSignalingChannel =
    software.amazon.awscdk.services.kinesisvideo.CfnSignalingChannel.Builder
      .create(stackCtx, internalResourceId)
      .name(name.orNull)
      .`type`(`type`.orNull)
      .tags(tags.map(_.asJava).orNull)
      .messageTtlSeconds(messageTtlSeconds.orNull)
      .build()
}
