package io.burkard.cdk.services.kinesisanalytics.cfnApplicationV2

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ApplicationConfigurationProperty {

  def apply(
    applicationCodeConfiguration: Option[software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.ApplicationCodeConfigurationProperty] = None,
    zeppelinApplicationConfiguration: Option[software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.ZeppelinApplicationConfigurationProperty] = None,
    sqlApplicationConfiguration: Option[software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.SqlApplicationConfigurationProperty] = None,
    environmentProperties: Option[software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.EnvironmentPropertiesProperty] = None,
    applicationSnapshotConfiguration: Option[software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.ApplicationSnapshotConfigurationProperty] = None,
    vpcConfigurations: Option[List[_]] = None,
    flinkApplicationConfiguration: Option[software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.FlinkApplicationConfigurationProperty] = None
  ): software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.ApplicationConfigurationProperty =
    (new software.amazon.awscdk.services.kinesisanalytics.CfnApplicationV2.ApplicationConfigurationProperty.Builder)
      .applicationCodeConfiguration(applicationCodeConfiguration.orNull)
      .zeppelinApplicationConfiguration(zeppelinApplicationConfiguration.orNull)
      .sqlApplicationConfiguration(sqlApplicationConfiguration.orNull)
      .environmentProperties(environmentProperties.orNull)
      .applicationSnapshotConfiguration(applicationSnapshotConfiguration.orNull)
      .vpcConfigurations(vpcConfigurations.map(_.asJava).orNull)
      .flinkApplicationConfiguration(flinkApplicationConfiguration.orNull)
      .build()
}
