package io.burkard.cdk.services.kendra.cfnDataSource

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object OneDriveUsersProperty {

  def apply(
    oneDriveUserS3Path: Option[software.amazon.awscdk.services.kendra.CfnDataSource.S3PathProperty] = None,
    oneDriveUserList: Option[List[String]] = None
  ): software.amazon.awscdk.services.kendra.CfnDataSource.OneDriveUsersProperty =
    (new software.amazon.awscdk.services.kendra.CfnDataSource.OneDriveUsersProperty.Builder)
      .oneDriveUserS3Path(oneDriveUserS3Path.orNull)
      .oneDriveUserList(oneDriveUserList.map(_.asJava).orNull)
      .build()
}
