package io.burkard.cdk.services.iotwireless

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnNetworkAnalyzerConfigurationProps {

  def apply(
    name: String,
    description: Option[String] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    wirelessDevices: Option[List[String]] = None,
    traceContent: Option[AnyRef] = None,
    wirelessGateways: Option[List[String]] = None
  ): software.amazon.awscdk.services.iotwireless.CfnNetworkAnalyzerConfigurationProps =
    (new software.amazon.awscdk.services.iotwireless.CfnNetworkAnalyzerConfigurationProps.Builder)
      .name(name)
      .description(description.orNull)
      .tags(tags.map(_.asJava).orNull)
      .wirelessDevices(wirelessDevices.map(_.asJava).orNull)
      .traceContent(traceContent.orNull)
      .wirelessGateways(wirelessGateways.map(_.asJava).orNull)
      .build()
}
