package io.burkard.cdk.services.iottwinmaker

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnEntity {

  def apply(
    internalResourceId: String,
    workspaceId: String,
    entityName: String,
    entityId: Option[String] = None,
    description: Option[String] = None,
    tags: Option[Map[String, String]] = None,
    components: Option[Map[String, _]] = None,
    parentEntityId: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.iottwinmaker.CfnEntity =
    software.amazon.awscdk.services.iottwinmaker.CfnEntity.Builder
      .create(stackCtx, internalResourceId)
      .workspaceId(workspaceId)
      .entityName(entityName)
      .entityId(entityId.orNull)
      .description(description.orNull)
      .tags(tags.map(_.asJava).orNull)
      .components(components.map(_.asJava).orNull)
      .parentEntityId(parentEntityId.orNull)
      .build()
}
