package io.burkard.cdk.services.iot

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnCACertificateProps {

  def apply(
    status: String,
    caCertificatePem: String,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    certificateMode: Option[String] = None,
    autoRegistrationStatus: Option[String] = None,
    verificationCertificatePem: Option[String] = None,
    registrationConfig: Option[AnyRef] = None
  ): software.amazon.awscdk.services.iot.CfnCACertificateProps =
    (new software.amazon.awscdk.services.iot.CfnCACertificateProps.Builder)
      .status(status)
      .caCertificatePem(caCertificatePem)
      .tags(tags.map(_.asJava).orNull)
      .certificateMode(certificateMode.orNull)
      .autoRegistrationStatus(autoRegistrationStatus.orNull)
      .verificationCertificatePem(verificationCertificatePem.orNull)
      .registrationConfig(registrationConfig.orNull)
      .build()
}
