package io.burkard.cdk.services.iam

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object ServicePrincipalOpts {

  def apply(
    region: Option[String] = None,
    conditions: Option[Map[String, _]] = None
  ): software.amazon.awscdk.services.iam.ServicePrincipalOpts =
    (new software.amazon.awscdk.services.iam.ServicePrincipalOpts.Builder)
      .region(region.orNull)
      .conditions(conditions.map(_.asJava).orNull)
      .build()
}
