package io.burkard.cdk.services.guardduty

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnThreatIntelSetProps {

  def apply(
    format: String,
    location: String,
    detectorId: String,
    activate: Boolean,
    name: Option[String] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None
  ): software.amazon.awscdk.services.guardduty.CfnThreatIntelSetProps =
    (new software.amazon.awscdk.services.guardduty.CfnThreatIntelSetProps.Builder)
      .format(format)
      .location(location)
      .detectorId(detectorId)
      .activate(activate)
      .name(name.orNull)
      .tags(tags.map(_.asJava).orNull)
      .build()
}
