package io.burkard.cdk.services.guardduty

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnFilterProps {

  def apply(
    name: String,
    detectorId: String,
    description: String,
    findingCriteria: software.amazon.awscdk.services.guardduty.CfnFilter.FindingCriteriaProperty,
    rank: Number,
    action: String,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None
  ): software.amazon.awscdk.services.guardduty.CfnFilterProps =
    (new software.amazon.awscdk.services.guardduty.CfnFilterProps.Builder)
      .name(name)
      .detectorId(detectorId)
      .description(description)
      .findingCriteria(findingCriteria)
      .rank(rank)
      .action(action)
      .tags(tags.map(_.asJava).orNull)
      .build()
}
