package io.burkard.cdk.services.guardduty

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnDetectorProps {

  def apply(
    enable: Boolean,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    dataSources: Option[software.amazon.awscdk.services.guardduty.CfnDetector.CFNDataSourceConfigurationsProperty] = None,
    findingPublishingFrequency: Option[String] = None
  ): software.amazon.awscdk.services.guardduty.CfnDetectorProps =
    (new software.amazon.awscdk.services.guardduty.CfnDetectorProps.Builder)
      .enable(enable)
      .tags(tags.map(_.asJava).orNull)
      .dataSources(dataSources.orNull)
      .findingPublishingFrequency(findingPublishingFrequency.orNull)
      .build()
}
