package io.burkard.cdk.services.guardduty

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnDetector {

  def apply(
    internalResourceId: String,
    enable: Boolean,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    dataSources: Option[software.amazon.awscdk.services.guardduty.CfnDetector.CFNDataSourceConfigurationsProperty] = None,
    findingPublishingFrequency: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.guardduty.CfnDetector =
    software.amazon.awscdk.services.guardduty.CfnDetector.Builder
      .create(stackCtx, internalResourceId)
      .enable(enable)
      .tags(tags.map(_.asJava).orNull)
      .dataSources(dataSources.orNull)
      .findingPublishingFrequency(findingPublishingFrequency.orNull)
      .build()
}
