package io.burkard.cdk.services.fsx

sealed abstract class LustreDataCompressionType(val underlying: software.amazon.awscdk.services.fsx.LustreDataCompressionType)
  extends Product
    with Serializable

object LustreDataCompressionType {
  implicit def toAws(value: LustreDataCompressionType): software.amazon.awscdk.services.fsx.LustreDataCompressionType =
    Option(value).map(_.underlying).orNull

  case object None
    extends LustreDataCompressionType(software.amazon.awscdk.services.fsx.LustreDataCompressionType.NONE)

  case object Lz4
    extends LustreDataCompressionType(software.amazon.awscdk.services.fsx.LustreDataCompressionType.LZ4)
}
