package io.burkard.cdk.services.fsx

sealed abstract class LustreAutoImportPolicy(val underlying: software.amazon.awscdk.services.fsx.LustreAutoImportPolicy)
  extends Product
    with Serializable

object LustreAutoImportPolicy {
  implicit def toAws(value: LustreAutoImportPolicy): software.amazon.awscdk.services.fsx.LustreAutoImportPolicy =
    Option(value).map(_.underlying).orNull

  case object None
    extends LustreAutoImportPolicy(software.amazon.awscdk.services.fsx.LustreAutoImportPolicy.NONE)

  case object New
    extends LustreAutoImportPolicy(software.amazon.awscdk.services.fsx.LustreAutoImportPolicy.NEW)

  case object NewChanged
    extends LustreAutoImportPolicy(software.amazon.awscdk.services.fsx.LustreAutoImportPolicy.NEW_CHANGED)

  case object NewChangedDeleted
    extends LustreAutoImportPolicy(software.amazon.awscdk.services.fsx.LustreAutoImportPolicy.NEW_CHANGED_DELETED)
}
