package io.burkard.cdk.services.fsx

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnSnapshot {

  def apply(
    internalResourceId: String,
    name: String,
    volumeId: String,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.fsx.CfnSnapshot =
    software.amazon.awscdk.services.fsx.CfnSnapshot.Builder
      .create(stackCtx, internalResourceId)
      .name(name)
      .volumeId(volumeId)
      .tags(tags.map(_.asJava).orNull)
      .build()
}
