package io.burkard.cdk.services.evidently

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnSegmentProps {

  def apply(
    name: String,
    pattern: Option[String] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    description: Option[String] = None
  ): software.amazon.awscdk.services.evidently.CfnSegmentProps =
    (new software.amazon.awscdk.services.evidently.CfnSegmentProps.Builder)
      .name(name)
      .pattern(pattern.orNull)
      .tags(tags.map(_.asJava).orNull)
      .description(description.orNull)
      .build()
}
