package io.burkard.cdk.services.evidently

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnExperiment {

  def apply(
    internalResourceId: String,
    name: String,
    project: String,
    metricGoals: List[_],
    treatments: List[_],
    onlineAbConfig: software.amazon.awscdk.services.evidently.CfnExperiment.OnlineAbConfigObjectProperty,
    removeSegment: Option[Boolean] = None,
    samplingRate: Option[Number] = None,
    description: Option[String] = None,
    tags: Option[List[_ <: software.amazon.awscdk.CfnTag]] = None,
    segment: Option[String] = None,
    runningStatus: Option[software.amazon.awscdk.services.evidently.CfnExperiment.RunningStatusObjectProperty] = None,
    randomizationSalt: Option[String] = None
  )(implicit stackCtx: software.amazon.awscdk.Stack): software.amazon.awscdk.services.evidently.CfnExperiment =
    software.amazon.awscdk.services.evidently.CfnExperiment.Builder
      .create(stackCtx, internalResourceId)
      .name(name)
      .project(project)
      .metricGoals(metricGoals.asJava)
      .treatments(treatments.asJava)
      .onlineAbConfig(onlineAbConfig)
      .removeSegment(removeSegment.map(Boolean.box).orNull)
      .samplingRate(samplingRate.orNull)
      .description(description.orNull)
      .tags(tags.map(_.asJava).orNull)
      .segment(segment.orNull)
      .runningStatus(runningStatus.orNull)
      .randomizationSalt(randomizationSalt.orNull)
      .build()
}
