package io.burkard.cdk.services.events.targets

@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object SnsTopic {

  def apply(
    topic: software.amazon.awscdk.services.sns.ITopic,
    message: Option[software.amazon.awscdk.services.events.RuleTargetInput] = None,
    maxEventAge: Option[software.amazon.awscdk.Duration] = None,
    retryAttempts: Option[Number] = None,
    deadLetterQueue: Option[software.amazon.awscdk.services.sqs.IQueue] = None
  ): software.amazon.awscdk.services.events.targets.SnsTopic =
    software.amazon.awscdk.services.events.targets.SnsTopic.Builder
      .create(topic)
      .message(message.orNull)
      .maxEventAge(maxEventAge.orNull)
      .retryAttempts(retryAttempts.orNull)
      .deadLetterQueue(deadLetterQueue.orNull)
      .build()
}
