package io.burkard.cdk.services.events

import scala.collection.JavaConverters._

@scala.annotation.nowarn("cat=deprecation")
@SuppressWarnings(Array("org.wartremover.warts.DefaultArguments", "org.wartremover.warts.Null", "DisableSyntax.null"))
object CfnEndpointProps {

  def apply(
    eventBuses: List[_],
    name: String,
    routingConfig: software.amazon.awscdk.services.events.CfnEndpoint.RoutingConfigProperty,
    description: Option[String] = None,
    roleArn: Option[String] = None,
    replicationConfig: Option[software.amazon.awscdk.services.events.CfnEndpoint.ReplicationConfigProperty] = None
  ): software.amazon.awscdk.services.events.CfnEndpointProps =
    (new software.amazon.awscdk.services.events.CfnEndpointProps.Builder)
      .eventBuses(eventBuses.asJava)
      .name(name)
      .routingConfig(routingConfig)
      .description(description.orNull)
      .roleArn(roleArn.orNull)
      .replicationConfig(replicationConfig.orNull)
      .build()
}
